
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

    public class MediaManager
    {
      private HashMap images, audio;

      public MediaManager()
      {
        images = new HashMap();
        audio = new HashMap();
      }

      private GraphicsConfiguration getGraphicsConfiguration()
      {
		   GraphicsEnvironment ge =
		  		            GraphicsEnvironment.getLocalGraphicsEnvironment();
		   GraphicsDevice gd = ge.getDefaultScreenDevice();
		   return gd.getDefaultConfiguration();

	  }

      private BufferedImage getBufferedImage(String imageName)
      {
		  BufferedImage img = (BufferedImage) images.get(imageName);
		  if (img == null)
		  {
			  URL url=null;
			  Class cl = getClass();
			  ClassLoader loader = cl.getClassLoader();
			  url = loader.getResource("res/images/" + imageName);
			  try
			  {
				  img = ImageIO.read(url);
			  } catch (Exception e)
			  {
			  }
			  images.put(imageName,img);
		  }

          return img;
	  }

      public BufferedImage getBitmap(String imageName)
      {
		  GraphicsConfiguration gc = getGraphicsConfiguration();

		  BufferedImage original = getBufferedImage(imageName);

		  BufferedImage accelerated = gc.createCompatibleImage(original.getWidth(),original.getHeight(),original.getColorModel().getTransparency());
		  Graphics2D g = accelerated.createGraphics();
		  g.drawRenderedImage(original,null);
		  g.dispose();

		  return accelerated;
      }

      private AudioClip getAudioClip(String soundName)
      {
		  AudioClip au = (AudioClip) audio.get(soundName);
		  if (au == null)
		  {
			  URL url=null;
			  Class cl = getClass();
			  ClassLoader loader = cl.getClassLoader();
			  url = loader.getResource("res/sounds/" + soundName);

			  au = Applet.newAudioClip(url);

			  audio.put(soundName,au);
		  }
          return au;
	  }

      public void playSoundEffect(String soundName)
      {
		  AudioClip fx = getAudioClip(soundName);
		  fx.play();
	  }

	  public void playMusic(String soundName)
	  {
		  AudioClip music = getAudioClip(soundName);
		  music.loop();
	  }
}
